<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';
header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit();
}

// Check if sale_id is provided
if (!isset($_GET['sale_id'])) {
    echo json_encode(['success' => false, 'message' => 'Sale ID is required']);
    exit();
}

$sale_id = isset($_GET['sale_id']) ? intval($_GET['sale_id']) : 0;
if (!$sale_id) {
    echo json_encode(['success' => false, 'message' => 'Missing or invalid sale_id']);
    exit;
}

try {
    // Get credit sale info
    $stmt = $pdo->prepare('
        SELECT s.id as sale_id, s.invoice_number, s.created_at, s.total_amount, s.status, s.customer_id, c.name as customer_name, ct.id as credit_transaction_id, ct.amount, ct.status as credit_status
        FROM sales s
        LEFT JOIN customers c ON s.customer_id = c.id
        LEFT JOIN credit_transactions ct ON s.id = ct.sale_id
        WHERE s.id = ? AND s.payment_method = "credit" LIMIT 1
    ');
    $stmt->execute([$sale_id]);
    $credit = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$credit) {
        echo json_encode(['success' => false, 'message' => 'Credit sale not found']);
        exit;
    }

    // Get payment history for this credit transaction
    $payments = [];
    
    // First, get any payments made against this credit (from credit_payments table)
    if (!empty($credit['credit_transaction_id'])) {
        $stmt = $pdo->prepare('
            SELECT amount, payment_method, created_at, (SELECT username FROM users WHERE id = cp.created_by) as received_by
            FROM credit_payments cp
            WHERE credit_transaction_id = ?
            ORDER BY created_at ASC
        ');
        $stmt->execute([$credit['credit_transaction_id']]);
        $payments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    // Also get the initial sale payment details (from sale_payments table)
    $stmt = $pdo->prepare('
        SELECT amount, method as payment_method, created_at, NULL as received_by
        FROM sale_payments sp
        WHERE sale_id = ?
        ORDER BY created_at ASC
    ');
    $stmt->execute([$sale_id]);
    $salePayments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Combine both payment arrays
    $payments = array_merge($salePayments, $payments);

    // Get all items for this sale
    $items = [];
    $stmt = $pdo->prepare('
        SELECT si.*, p.name as product_name, p.serial_no
        FROM sale_items si
        JOIN products p ON si.product_id = p.id
        WHERE si.sale_id = ?
    ');
    $stmt->execute([$sale_id]);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'credit' => $credit,
        'payments' => $payments,
        'items' => $items
    ]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?> 